/*
 * CondimentDecorator.java
 *
 * Created on March 31, 2007, 5:37 PM
 *
 * Decorators for our decorator pattern.
 */

package decoratorprogram;


/*
 * Superclass for decorators 
*/
public abstract class CondimentDecorator extends Beverage
{
    /*
     * Reference to wrapped beverage
    */
    protected Beverage beverage;
}

/*
 * Decorator concrete class
*/
class Mocha extends CondimentDecorator
{
    static double cost = 0.30;
    
    public Mocha(Beverage beverage)
    {
	this.beverage = beverage;
    }
    
    public double Cost()
    {
	return this.beverage.Cost() + cost;
    }
}

/*
 * Decorator concrete class
*/
class Milk extends CondimentDecorator
{
    static double cost = 0.25;
    
    public Milk(Beverage beverage)
    {
	this.beverage = beverage;
    }
    
    public double Cost()
    {
	return this.beverage.Cost() + cost;
    }
}

/*
 * Decorator concrete class
*/
class Soya extends CondimentDecorator
{
    static double cost = 0.40;
    
    public Soya(Beverage beverage)
    {
	this.beverage = beverage;
    }
    
    public double Cost()
    {
	return this.beverage.Cost() + cost;
    }
}

/*
 * Decorator concrete class
*/
class WhippedCream extends CondimentDecorator
{
    static double cost = 0.45;
    
    public WhippedCream(Beverage beverage)
    {
	this.beverage = beverage;
    }
    
    public double Cost()
    {
	return this.beverage.Cost() + cost;
    }
}